<?php

namespace NewHeap\Component\Mautic\Connector\Application\Configuration;

/**
 * Config
 *
 * @package     NewHeap\Component\Mautic\Connector\Application
 * @author      Lars van den Bosch <lars@newheap.com>
 */
class Config
{
    /* @var string */
    public $applicationRoot;

    /* @var string */
    public $applicationAssetsDirectory;

    /* @var array */
    public $extraApplicationDirectories = array();

    /**
     * @param $applicationRoot
     * @param $extraApplicationDirectories
     * @param $applicationAssetsDirectory
     */
    public function __construct(
        $applicationAssetsDirectory,
        $applicationRoot,
        $extraApplicationDirectories)
    {
        if(true === is_array($extraApplicationDirectories))
        {
            $this->extraApplicationDirectories = $extraApplicationDirectories;
        }

        $this->applicationRoot = $applicationRoot;
        $this->applicationAssetsDirectory = $applicationAssetsDirectory;
        $this->extraApplicationDirectories = $extraApplicationDirectories;
    }
}
