<?php
namespace NewHeap\Component\Mautic\Connector\Application\Database;

use NewHeap\Component\Mautic\Connector\Application\Service\HttpService;

class PageHits
{
    const PAGE_HIT_TABLE = 'nh_mautic_page_hit';

    private $wpdb;

    public function __construct()
    {
        global $wpdb;

        $this->wpdb = $wpdb;

        add_action('init', [$this, 'create_database_table']);

        add_action('wp_ajax_nh_tracking', [$this, 'get_mautic_device_details']);
        add_action('wp_ajax_nopriv_nh_tracking', [$this, 'get_mautic_device_details']);
    }

    /**
     * Create database table if it doesn't exist
     *
     * @author Ferhat Ileri <ferhat@newheap.com>
     */
    public function create_database_table()
    {
        $charset_collate = $this->wpdb->get_charset_collate();
        $table_name = $this->wpdb->prefix . self::PAGE_HIT_TABLE;


        if ($_SERVER['REMOTE_ADDR'] !== '23.97.225.71') {
//            var_dump($charset_collate);
//            var_dump($table_name);
//            var_dump(empty($this->wpdb->get_results("SHOW TABLES LIKE '" . $table_name . "'")));
        }

        // Check if the table doesn't exists. Then create the table
        if (empty($this->wpdb->get_results("SHOW TABLES LIKE '" . $table_name . "'"))) {

            $sql = "CREATE TABLE {$table_name} (
                id int(9) NOT NULL AUTO_INCREMENT,
                client_data text NOT NULL,
                client_ip varchar(255) NOT NULL,
                visited_at datetime,
                synced boolean DEFAULT false,
                PRIMARY KEY  (id)
            ) {$charset_collate};";

            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta($sql);
        }
    }

    /**
     * Insert page visit in database
     *
     * @param $clientData
     * @param bool $synced
     * @author Ferhat Ileri <ferhat@newheap.com>
     */
    public function register_page_visit($clientData, $synced = false)
    {
        // Data to be inserted
        $data = [];

        // Get the full url with protoocol and parameters
        $data['client_data'] = json_encode($clientData);
        $data['client_ip'] = (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];
        $data['synced'] = $synced;
        $data['visited_at'] = date('Y-m-d H:i:s');

        // Get the table name
        $table = $this->wpdb->prefix . self::PAGE_HIT_TABLE;

        $format = ['%s','%s'];

        // Insert sanitized data
        $this->wpdb->insert($table, $data, $format);
    }

    /**
     * Post client data to Mautic
     *
     * @author Ferhat Ileri <ferhat@newheap.com>
     */
    public static function get_mautic_device_details()
    {
        $clientData = [
            'page_title' => $_POST['clientInfo']['page_title'],
            'page_language' => $_POST['clientInfo']['page_language'],
            'page_referrer' => $_POST['clientInfo']['page_referrer'],
            'page_url' => $_POST['clientInfo']['page_url'],
            'resolution' => $_POST['clientInfo']['resolution'],
            'timezone_offset' => $_POST['clientInfo']['timezone_offset'],
            'platform' => $_POST['clientInfo']['platform'],
            'do_not_track' => $_POST['clientInfo']['do_not_track'],
        ];

        $options = get_option('wpmautic_options');
        $mauticBaseUrl =  $options['base_url'] . '/mtc/event';

        $ipaddress = null;
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');

        if($ipaddress) {
            $postData = json_decode(HttpService::postRequest($mauticBaseUrl, $clientData));
        } else {
            $postData = json_decode(HttpService::postRequest($mauticBaseUrl, $clientData, ["X-FORWARDED-FOR: $ipaddress"]));
        }

        // Check if success
        if (property_exists($postData, 'success') && $postData->success === 1) {
            // Store in database as synced
            self::register_page_visit($clientData, true);
        } else {
            // Store in database as not synced
            self::register_page_visit($clientData, false);
        }

        exit;
    }
}
