<?php

namespace NewHeap\Component\Mautic\Connector\Application\Service;

/**
 * HttpService
 *
 * @package     NewHeap\Component\Mautic\Connector\Application\Service
 * @author      Lars van den Bosch <lars@newheap.com>
 */
class HttpService
{
    public function __construct()
    {
    }

    public static function postRequest($url, $data, $extraHeader = null, $cookies = null)
    {
        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

        if(null !== $extraHeader && is_array($extraHeader))
        {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $extraHeader);
        }

        if(!empty($cookies)) {
            curl_setopt($curl, CURLOPT_COOKIE, $cookies);
        }

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

    public static function getRequest($url, $extraHeader = null)
    {
        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_POST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

        if(null !== $extraHeader && is_array($extraHeader))
        {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $extraHeader);
        }

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }
}