<?php

namespace NewHeap\Component\Mautic\Connector\Application\Service;
use NewHeap\Component\Mautic\Connector\Application\Model\MauticFormElementModel;

/**
 * VisualComposerService
 *
 * @package     NewHeap\Component\Mautic\Connector\Application\Service
 * @author      Lars van den Bosch <lars@newheap.com>
 */
class VisualComposerService
{
    const SESSION_FORM_PREFIX = "";

    /** @var  \DOMElement */
    private $formWrapperElement;

    /** @var  \DOMElement */
    private $innerFormElement;

    /** @var  \DOMElement */
    private $innerFormElementSubmitButton;

    /** @var  MauticFormElementModel[] */
    public $selectableFormElementCollection;

    public function __construct()
    {
        add_shortcode( 'mautic_connector_form', array( $this, 'mauticConnectorForm' ) );
        add_shortcode( 'mautic_connector_form_element', array( $this, 'mauticConnectorFormElement' ) );
        add_shortcode( 'mautic_connector_form_element_submit_response_message', array( $this, 'mauticConnectorFormElementSubmitResponseMessage' ) );
        add_shortcode( 'mautic_connector_form_element_resolve_html', array( $this, 'mauticConnectorFormElementResolveHtml' ) );

        add_action( 'admin_enqueue_scripts', array( $this, 'loadCssAndJs' ) );

        $this->performVcMap();
    }

    public function performVcMap()
    {
        $options = get_option('wpmautic_options');

        add_action( 'vc_before_init', function() use($options) {

            vc_map( array(
                "name" => __("Mautic formulier", "newheap_vc"),
                "description" => __("Show Mautic form from your Mautic environment.","newheap_vc"),
                "base" => "mautic_connector_form",
                "class" => "mautic_connector_form",
                "icon" => plugins_url( 'Mautic_Logo_LB.png', (__DIR__."/../../../") ),
                "as_parent" => array('only' => 'vc_column_text,mautic_connector_form_element,mautic_connector_form_element_submit_response_message'),
                "category" => __('NewHeap VC Addons'),
                'is_container' => false,
                'content_element' => true,
                "show_settings_on_create" => true,
                "controls" => "full",
                "params" => array(
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __("Mautic environment base URL"),
                        "param_name" => "mautic_connector_environment_base_url",
                        "value" =>  $options['base_url'],
                        "description" => __("Please enter the Mautic enivronment base url. (https://newheap.com/staging/contentxperience/mautic)."),
                        "group"=> "General",
                    ),
                    array(
                        "type" => "dropdown",
                        "heading" => __("Mautic form ID"),
                        "param_name" => "mautic_connector_environment_form_id",
                        "holder" => "div",
                        "class" => "",
                        "value" => [],
                        "description" => __("Please select the form ID of the form within your Mautic environment", "newheap_vc"),
                        "group"=> "General"
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __("Form element wapper id"),
                        "param_name" => "mautic_connector_form_element_id",
                        "value" => __(""),
                        "description" => __("Optional: add form wrapper element id."),
                        "group" => "Optional",
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __("Form element wrapper class"),
                        "param_name" => "mautic_connector_form_element_class",
                        "value" => __(""),
                        "description" => __("Optional: add form wrapper element classes."),
                        "group" => "Optional",
                    )
                ),
                "js_view" => 'VcColumnView'
            ));

            vc_map( array(
                "name" => __("Formulier element", "newheap_vc"),
                "base" => "mautic_connector_form_element",
                "category" => __('NewHeap VC Addons'),
                "content_element" => true,
                'is_container' => false,
                "controls" => "full",
                "show_settings_on_create" => false,
                "html_template" => dirname( __FILE__ ) . '/../../vc_templates/mautic_connector_form_element.php',
                "as_child" => array('only' => 'mautic_connector_form'), // Use only|except attributes to limit parent (separate multiple values with comma)

                //TODO: JS VIEW KAN ON LOADED DAN LIJST AL VERVANGEN IPV HOVER ELEMENT
                'js_view'  => 'ViewMauticConnectorFormElement', // JS View name for backend. Can be used to override or add some logic for shortcodes in backend (cloning/rendering/deleting/editing).
                "params" => array(
                    // add params same as with any other content element
                    array(
                        "type" => "dropdown",
                        "heading" => __("Form element", "newheap_vc"),
                        "param_name" => "mautic_connector_form_element",
                        "holder" => "div",
                        "class" => "mautic_connector_form_element_value",
                        "value" => ["List will be loaded on mouse hover" => "-1"],
                        "description" => __("Select the form element you want to add to the form", "newheap_vc"),
                        "group"=> "General"
                    )
                )
            ));

            vc_map( array(
                "name" => __("Formulier validatie/bericht", "newheap_vc"),
                "base" => "mautic_connector_form_element_submit_response_message",
                "category" => __('NewHeap VC Addons'),
                "content_element" => true,
                'is_container' => false,
                "controls" => "full",
                "show_settings_on_create" => false,
                "as_child" => array('only' => 'mautic_connector_form'),
                "params" => array(
                )
            ));
        });
    }

    /**
     * @param $content
     * @param bool $autop
     *
     * @return string
     * @since 4.2
     */
    function wpb_js_remove_wpautop( $content, $autop = false ) {
        if ($autop) {
            $content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
        }

        return do_shortcode( shortcode_unautop( $content ) );
    }


    public function mauticConnectorForm($atts, $content = null )
    {

        extract( shortcode_atts( array(
            'mautic_connector_environment_base_url' => '',
            'mautic_connector_environment_form_id' => '',
            'mautic_connector_form_element_class' => '',
            'mautic_connector_form_element_id' => ''
        ), $atts ) );

        $options = get_option('wpmautic_options');
        if(empty($atts['mautic_connector_environment_base_url'])) {
            $atts['mautic_connector_environment_base_url'] = $options['base_url'];
        }

        $content = $this->wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content

        $elementWrapperAttributes = "";

        if(!empty($atts['mautic_connector_form_element_class']))
        {
            $elementWrapperAttributes .= ' class="'.$atts['mautic_connector_form_element_class'].'"';
        }

        if(!empty($atts['mautic_connector_form_element_id']))
        {
            $elementWrapperAttributes .= ' id="'.$atts['mautic_connector_form_element_id'].'"';
        } 

        //Load mautic form
        $formHtmlString = $this->loadMauticForm($atts['mautic_connector_environment_base_url'], $atts['mautic_connector_environment_form_id']);

        if(empty($content)) {
              $mauticConnectorApplicationKernel = \NewHeap\Component\Mautic\Connector\Application\ApplicationKernel::getInstance();
              $mauticConnectorApplicationKernel->visualComposerService->loadMauticForm($options['base_url'], $attributes['mautic_connector_environment_form_id']);

                $selectCollectionResult = call_user_func(function () use ($mauticConnectorApplicationKernel) {
                    $result = [];

                    if (is_array($mauticConnectorApplicationKernel->visualComposerService->selectableFormElementCollection)) {
                        foreach ($mauticConnectorApplicationKernel->visualComposerService->selectableFormElementCollection as $elementModel) {
                            $result[] = $elementModel->domElementId;
                        }
                    }

                    return $result;
                });

                $content = "";
                $count = 1;
                foreach ($selectCollectionResult as $result) {
                    if ($count != count($selectCollectionResult)) {
                        $content .= "[mautic_connector_form_element_resolve_html element_key='" . $result . "']";
                    }
                    $count++;
                }
                $content .= "[mautic_connector_form_element_submit_response_message]";
        }

        $postUrl = $atts['mautic_connector_environment_base_url'] . "/form/submit?formId=" . $atts['mautic_connector_environment_form_id'];

        ob_start();

        ?>
            <div class="mauticform_wrapper <?php echo $atts['mautic_connector_form_element_class']; ?>">
                <form class="mautic_connector_form_form" autocomplete="false" role="form" method="post"<?=$elementWrapperAttributes?> data-mautic-form-id="<?=$atts['mautic_connector_environment_form_id']?>">

                    <div class="mauticform-innerform">
                        <?php
                        echo do_shortcode($content);
                        ?>
                        <input type="hidden" name="mauticform[formId]" value="<?=$atts['mautic_connector_environment_form_id']?>">
                    </div>
                </form>
            </div>
        <?php

        return ob_get_clean();
    }

    public function mauticConnectorFormElement($atts, $content = null )
    {
        extract( shortcode_atts( array(
            'mautic_connector_form_element' => ''
        ), $atts ) );

        $content = $this->wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content


        ob_start();

        ?>
            [mautic_connector_form_element_resolve_html element_key="<?=$atts['mautic_connector_form_element']?>"][/mautic_connector_form_element_resolve_html]
        <?php

        return ob_get_clean();
    }

    public function mauticConnectorFormElementResolveHtml($atts, $content = null )
    {

        extract( shortcode_atts( array(
            'element_key' => ''
        ), $atts ) );

        $content = $this->wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content
        do_shortcode($content);


        $options = get_option('wpmautic_options');

        ob_start();

        /** @var MauticFormElementModel $formElement */
        $formElement = null;

        /** @var MauticFormElementModel $elementModel */
        foreach($this->selectableFormElementCollection as $elementModel)
        {
            if($elementModel->domElementId == $atts["element_key"])
            {
                $formElement = $elementModel;
                break;
            }
        }
		
        if(strstr($formElement->domElement->tagName, "button") || strstr($formElement->domElementId, "_submit")) {
            echo '<div class="g-recaptcha" data-sitekey="'.$options['wpmautic_captcha_key'].'"></div>';
        }

        echo ($formElement == null) ? "" : $formElement->domElementHtml;

        return ob_get_clean();
    }

    public function mauticConnectorFormElementSubmitResponseMessage($atts, $content = null )
    {

        extract(shortcode_atts(array(
        ), $atts));

        $content = $this->wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content
        do_shortcode($content);

        ob_start();

        ?>
            <div style="position:relative;" class="mauticform-message mautic_connector_form_element_submit_response_message"></div>
            <input type="text" name="phone" value" style="display:none;">
        <?php

        return ob_get_clean();
    }

    public function loadCssAndJs()
    {
        wp_register_style( 'vc_extend_style', plugins_url('../../Assets/vc_extend.css', __FILE__) );
        wp_enqueue_style( 'vc_extend_style' );

        // If you need any javascript files on front end, here is how you can load them.
        wp_enqueue_script( 'vc_extend_js', plugins_url('../../Assets/vc_extend.js', __FILE__), array('jquery') );
    }

    public function loadMauticForm($baseUrl, $formId)
    {
        $cacheFile = (__DIR__) . "/cache/" . md5($baseUrl . $formId . date("Y-m-d"));
		
        
        $baseUrl = trim($baseUrl);
        $formId = trim($formId);
		

        //Check if cached version
        if(file_exists($cacheFile)) {
            $httpResponseString = file_get_contents($cacheFile, true);
        } else {
            $url = trim($baseUrl."/form/".$formId);
            $httpResponseString = HttpService::getRequest($url);
            $myfile = fopen($cacheFile, "w") or die("Unable to open file!");
            fwrite($myfile, $httpResponseString);
        }

        $result = "";

        $doc = new \DOMDocument();
        @$doc->loadHTML('<?xml encoding="utf-8" ?>' .$httpResponseString);
        $xp = new \DOMXpath($doc);
        $formWrapperElements = $xp->query('//*[@class="mauticform_wrapper"]');
        $xp2 = new \DOMXpath($doc);
        $innerFormElements = $xp2->query('//*[contains(@class,"mauticform-page-wrapper")]');
        $xp3 = new \DOMXpath($doc);
        $innerFormElementSubmitButtons = $xp3->query('//*[@type="submit"]');

        if(empty($formWrapperElements) || count($formWrapperElements) < 1)
        {
            return $result;
        }

        if(empty($innerFormElements) || count($innerFormElements) < 1)
        {

        }

        $this->formWrapperElement = $formWrapperElements[0];
        $this->innerFormElement = $innerFormElements[0];
        $this->innerFormElementSubmitButton = $innerFormElementSubmitButtons[0];

        $this->selectableFormElementCollection = [];

        /** @var \DOMElement $innerFormChildNode */
        foreach($this->innerFormElement->childNodes as $innerFormChildNode)
        {
            if(!$innerFormChildNode instanceof \DOMElement)
            {
                continue;
            }

            $elementModel = new MauticFormElementModel();

            $elementModel->domElementId = $innerFormChildNode->getAttribute('id');
            $elementModel->domElement = $innerFormChildNode;
            $elementModel->domElementHtml = $doc->saveHTML($innerFormChildNode);

            /** @var \DOMElement $innerFormChildNodeLabelElement */
            foreach($innerFormChildNode->getElementsByTagName("label") as $innerFormChildNodeLabelElement)
            {
                $elementModel->title = $innerFormChildNodeLabelElement->nodeValue;
                break;
            }

            if(empty($elementModel->title)) {
                foreach($innerFormChildNode->getElementsByTagName("input") as $innerFormChildNodeLabelElement)
                {
                    $elementModel->title = $innerFormChildNodeLabelElement->getAttribute('placeholder');
                    break;
                }
            }

            if(empty($elementModel->title)) {
                foreach($innerFormChildNode->getElementsByTagName("textarea") as $innerFormChildNodeLabelElement)
                {
                    $elementModel->title = $innerFormChildNodeLabelElement->getAttribute('placeholder');
                    break;
                }
            }

            if(empty($elementModel->title)) {
                foreach($innerFormChildNode->getElementsByTagName("input") as $innerFormChildNodeLabelElement)
                {
                    $elementModel->title = $innerFormChildNodeLabelElement->getAttribute('id');
                    break;
                }
            }

            if(empty($elementModel->title)) {
                foreach($innerFormChildNode->getElementsByTagName("select") as $innerFormChildNodeLabelElement)
                {
                    $elementModel->title = $innerFormChildNodeLabelElement->getAttribute('id');
                    break;
                }
            }

            $this->selectableFormElementCollection[] = $elementModel;
        }


        if ($this->innerFormElementSubmitButton instanceof \DOMElement) {

            $elementModel = new MauticFormElementModel();

            $elementModel->domElementId = $this->innerFormElementSubmitButton->getAttribute('id');
            $elementModel->domElement = $this->innerFormElementSubmitButton;
            $elementModel->domElementHtml = $doc->saveHTML($this->innerFormElementSubmitButton->parentNode);
            $elementModel->title = $this->innerFormElementSubmitButton->nodeValue ." [Submit button]";

            $this->selectableFormElementCollection[] = $elementModel;
        }

        return $httpResponseString;
    }
}
