var NewHeapTracker = {
    clientInfo: null,
    newHeapCookieOption: null,

    init: function() {
        this.checkCookie();

        if (typeof this.newHeapCookieOption === 'undefined' || this.newHeapCookieOption !== 'functional' && this.newHeapCookieOption !== 'initial') {
            this.getClientInfo()
        }
    },

    checkCookie: function() {
        this.newHeapCookieOption = getCookie('newheap-cookie-option');
    },

    getClientInfo: function() {
        this.clientInfo = {
            page_title: document.title,
            page_language: navigator.language,
            page_referrer: document.referrer,
            page_url: window.location.href,
            resolution: window.innerWidth + 'x' + window.innerHeight,
            timezone_offset: new Date().getTimezoneOffset(),
            platform: navigator.platform,
            do_not_track: navigator.doNotTrack
        };

        var data = {
            action: 'nh_tracking',
            clientInfo: this.clientInfo,
			tags: mauticTags
        };

        jQuery.ajax({
            url: nh_mautic_ajax.ajax_url,
            method: 'post',
            data: data,
        }).done(function(response) {
            // Empty response
        });
    }
};

jQuery(function() {
    NewHeapTracker.init();
});

function getCookie(name) {
    var value = "; " + document.cookie;
    var parts = value.split("; " + name + "=");
    if (parts.length == 2) return parts.pop().split(";").shift();
}
