var isLoaded = false;

document.onreadystatechange = function () {

    var elementLoadedClass = "vc-nh-loaded";

    var formElementString = ".mautic_connector_form_element"
    var formWrapper = null;
    var formElementWrapper = null;

    var selectListOptions = null;
    var newSelectedListOptions = null;

    var mauticFormId = null;
    var mauticBaseUrl = null;

    jQuery("body").delegate('div[data-element_type="mautic_connector_form_element"] .vc_control-btn-edit', "click", function(){
        var element = jQuery(this);

        formElementWrapper = element.parent().parent().parent();

        var maxLoop = 10000;

        formWrapper = formElementWrapper;

        for(var i = 0; i < maxLoop; i++)
        {
            formWrapper = formWrapper.parent();

            if(formWrapper.attr('data-element_type') == 'mautic_connector_form')
            {
                break;
            }
        }

        if(formWrapper.attr('data-element_type') != 'mautic_connector_form')
        {
            return;
        }

        loadFormElementContent();
    });

    jQuery("body").delegate('select[name="mautic_connector_form_element"]', "mouseenter", function(){
        var element = jQuery(this);

        if(element.hasClass("loaded") || selectListOptions == null || selectListOptions == undefined)
        {
            return;
        }

        var currentVal = element.attr("data-option");

        var newSelectedListOptions = stripExistingFormElementsFromSelectedListOptions(currentVal);
        console.log(newSelectedListOptions);

        element.empty();

        for (var property in newSelectedListOptions) {
            if (newSelectedListOptions.hasOwnProperty(property)) {

                if(property == undefined || property == null || property.length < 1 || property == "")
                {
                    continue;
                }

                if(currentVal != newSelectedListOptions[property])
                {
                    element.append('<option class="'+newSelectedListOptions[property]+'" value="'+newSelectedListOptions[property]+'">' + property + '</option>');
                }else{
                    element.append('<option selected="selected" class="'+newSelectedListOptions[property]+'" value="'+newSelectedListOptions[property]+'">' + property + '</option>');
                }
            }
        }

        element.addClass("loaded");
    });


    jQuery("body").bind('DOMNodeInserted', function(e) {
            if(jQuery('select[name="mautic_connector_environment_form_id"]').length >= 1) {
                  setTimeout(function() { loadFormsContent(); }, 300);
            } else {
                  isLoaded = false;
            }
    });

    jQuery("body").delegate('div[data-element_type="mautic_connector_form"] .vc-c-icon-mode_edit', "mouseenter", function(){
        var element = jQuery(this);

        formElementWrapper = element.parent();

        var maxLoop = 10000;

        formWrapper = formElementWrapper;

        for(var i = 0; i < maxLoop; i++)
        {
            formWrapper = formWrapper.parent();

            if(formWrapper.attr('data-element_type') == 'mautic_connector_form')
            {
                break;
            }
        }

        if(formWrapper.attr('data-element_type') != 'mautic_connector_form')
        {
            return;
        }

        loadFormsContent();
    });

    var loadFormElementContent = function(){

        var urlElement = formWrapper.find(".mautic_connector_environment_base_url").first();
        var formIdElement = formWrapper.find(".mautic_connector_environment_form_id").first();
        var formElementIdElement = formWrapper.find(".mautic_connector_form_element_id");
        var formElementClassElement = formWrapper.find(".mautic_connector_form_element_class");

        mauticBaseUrl = urlElement.text();
        mauticFormId = formIdElement.text();

        getMauticFormElementCollection(mauticBaseUrl, mauticFormId, function(data){
            if(data == null)
            {
                return;
            }

            selectListOptions = jQuery.parseJSON(data);
        });
    };

    var loadFormsContent = function(){
        if(isLoaded){ return; } 
        isLoaded = true;

        jQuery('select[name="mautic_connector_environment_form_id"]').html('<option class="-1" value="-1" selected="selected">Loading...</option>');

        var urlElement = jQuery('input[name="mautic_connector_environment_base_url"]').first();
        mauticBaseUrl = urlElement.text();
        getMauticFormCollection(mauticBaseUrl, function(data){
            if(data == null)
            {
                return;
            }

            newSelectedListOptions = jQuery.parseJSON(data);

            jQuery('select[name="mautic_connector_environment_form_id"]').empty();
            for (var i = 0; i < newSelectedListOptions.length; ++i) {
                jQuery('select[name="mautic_connector_environment_form_id"]').append('<option value="' + newSelectedListOptions[i]['id'] + '">' + newSelectedListOptions[i]['title'] + '</option>');
            }
        });

    };

    var getMauticFormElementCollection = function(baseUrl, formId, callBack)
    {
        var jqxhr = jQuery.post(ajaxurl, {
            action: 'mautic_connector_form_get_collection',
            baseUrl: mauticBaseUrl,
            formId: mauticFormId
        }, function(data) {
                callBack(data);
            })
            .done(function() {
            })
            .fail(function() {
            })
            .always(function() {
            });

        callBack(null);
    };

    var getMauticFormCollection = function(baseUrl, callBack)
    {
        var jqxhr = jQuery.post(ajaxurl, {
            action: 'mautic_connector_forms_get',
            baseUrl: mauticBaseUrl
        }, function(data) {
            callBack(data);
        })
        .done(function(data) {
        })
        .fail(function(data) {
        })
        .always(function(data) {
        });


        callBack(null);
    };

    var stripExistingFormElementsFromSelectedListOptions = function(currentValue)
    {
        if(formWrapper === undefined || formWrapper ===  null || typeof formWrapper !== 'object')
        {
            return;
        }

        var result = JSON.parse(JSON.stringify(selectListOptions));

        formWrapper.find(".mautic_connector_form_element_value").each(function( index ) {
            var elementValue = jQuery(this).text();

            for (var property in selectListOptions) {
                if (selectListOptions.hasOwnProperty(property)) {

                    if(selectListOptions[property] == elementValue)
                    {
                        delete result[property];
                    }
                }
            }
        });

        //
        //Add current selected
        //
        for (var property in selectListOptions) {
            if (selectListOptions.hasOwnProperty(property)) {

                if(selectListOptions[property] == currentValue)
                {
                    result[property] = selectListOptions[property];
                }
            }
        }

        return result;
    };

};