jQuery(document).ready(function(){
    
    grecaptchas = [];
    if(mauticLoadText === undefined) {
        var mauticLoadText = "Loading..."
    }

    var onloadCallback = function() {
        for (var i = 0, len = document.getElementsByClassName('g-recaptcha').length; i < len; i++) {
            grecaptchas.push(i);
        }
    };

    jQuery("body").delegate('.mautic_connector_form_form .mauticform-button', "ontouchstart mousedown keydown", function(e){
        jQuery(this).parent().parent().find('[name="phone"]').val('aMd039aNF!3n5ja');
    });

    jQuery("body").delegate('.mautic_connector_form_form', "submit", function(e){

        e.preventDefault();

        var formElement = jQuery(this);

        var responseMsgElement = formElement.find('.mautic_connector_form_element_submit_response_message').first();
        var submitBtn = formElement.find('button[type="submit"]').first();

        submitBtn.prop('disabled', true);
        responseMsgElement.html(mauticLoadText);
        postMauticForm(formElement.attr("data-mautic-form-id"), formElement.serializeArray(), function(data){


            try {
                data = jQuery.parseJSON(data);
            } catch(e) {
                responseMsgElement.html("Whoops, something went wrong. Please try again later or try to contact the administrator.");
                submitBtn.prop('disabled', false);
                return;
            }
            
            formElement.find('.mauticform-errormsg').hide();
            formElement.find('.mauticform-errormsg').html("");

            if(data.success == 0)
            {
                grecaptchas.forEach(function(i) {
                    grecaptcha.reset(i);
                });

                var message = "<ul>"

                for (var property in data.validationErrors) {
                    if (data.validationErrors.hasOwnProperty(property)) {

                        if(property == undefined || property == null || property.length < 1 || property == "")
                        {
                            continue;
                        }

                        var errorMsg = data.validationErrors[property];

                        if(jQuery('[data-validate="'+property+'"]').length >= 1) {
                            if(jQuery('[data-validate="'+property+'"]').find('.mauticform-errormsg').length <= 0) {
                                jQuery('[data-validate="'+property+'"]').append('<span class="mauticform-errormsg" style="display: none;"></span>');
                            }
                            jQuery('[data-validate="'+property+'"]').find('.mauticform-errormsg').show();
                            jQuery('[data-validate="'+property+'"]').find('.mauticform-errormsg').append("<li data-for-property='"+property+"'>" + errorMsg + "</li>");

                        } else {
                            message += "<li data-for-property='"+property+"'>" + errorMsg + "</li>";
                        }

                    }
                }

                if(data.errorMessage !== undefined)
                {
                    message += "<li>" + data.errorMessage + "</li>";
                }

                message += "</ul>";

                responseMsgElement.html(message);

                submitBtn.prop('disabled', false);
            } else if(data.success == 1)
            {

                    //
                    //Success
                    //
                    if(data.successMessage !== undefined) {
                        responseMsgElement.html(data.successMessage);
                    }

                    if(data.redirect !== undefined) {
                        responseMsgElement.html("");
                        window.location.href = data.redirect;
                    }


            }else{
                responseMsgElement.html("Whoops, something went wrong.");
                submitBtn.prop('disabled', false);
            }
        });
    });
    function getCookie(cname) {
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for(var i = 0; i <ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }
    function getParameterByName(name, url) {
        if (!url) url = window.location.href;
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }

    var postMauticForm = function(formId, formDataObj, callBack)
    {
        var jqxhr = jQuery.post(nh_mautic_ajax.ajax_url, {
            action: 'mautic_connector_form_form_post',
            mtc_id: getCookie("mtc_id"),
            mtc_sid: getCookie("mtc_sid"),
            utm_source: getParameterByName("utm_source"),
            utm_medium: getParameterByName("utm_medium"),
            utm_campaign: getParameterByName("utm_campaign"),
            formId: formId,
            formData: JSON.stringify(jQuery.map(formDataObj, function(value, index) {
                return [value];
            }))
        }, function(data) {
                callBack(data);
            })
            .done(function() {
            })
            .fail(function() {
                callBack(null);
            })
            .always(function() {

            });
    };
});

