<?php
/**
 * Plugin Name: Mautic connector
 * Plugin URI: https://marketingheap.com
 * Version: 1.5.1
 * Author: MarketingHeap
 * Description: MarketingHeap Mautic plugin for Wordpres.
 * Author URI: https://marketingheap.com
*/

use NewHeap\Component\Mautic\Connector\Application\Database\FormSubmissions;
use NewHeap\Component\Mautic\Connector\Application\Database\PageHits;

require_once (__DIR__) . "/recaptchalib.php";
require_once (__DIR__) . "/wpmautic.php";

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
    header( 'HTTP/1.0 403 Forbidden' );
    echo 'This file should not be accessed directly!';
    exit; // Exit if accessed directly
}

require (__DIR__).'/vendor/autoload.php';

if (session_status() == PHP_SESSION_NONE)
{
    session_start();
}

//Require the application config
require_once(__DIR__ . '/Application/Configuration/Config.php');

//Require the application kernel
require_once(__DIR__ . '/Application/ApplicationKernel.php');

try
{
    $mauticConnectorApplicationKernel = new \NewHeap\Component\Mautic\Connector\Application\ApplicationKernel(new NewHeap\Component\Mautic\Connector\Application\Configuration\Config(
        __DIR__ . "/Assets",
        __DIR__ . "/Application",
        null
    ));
}catch(\Exception $ex)
{

}

function getMauticConnector()
{
    return NewHeap\Component\Mautic\Connector\Application\ApplicationKernel::getInstance();
}


//
//Map this for shortcodeception..
//
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Mautic_Connector_Form extends WPBakeryShortCodesContainer {

        public function __construct( $settings ) {
            parent::__construct( $settings ); // !Important to call parent constructor to active all logic for shortcode.
        }

    }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Mautic_Connector_Form_Element extends WPBakeryShortCode {

        public function __construct( $settings ) {
            parent::__construct( $settings ); // !Important to call parent constructor to active all logic for shortcode.
        }
    }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Mautic_Connector_Form_Element_Submit_Response_Message extends WPBakeryShortCode {
    }
}

add_action( 'init', 'create_mautic_tags_taxonomy', 0 );
 
function create_mautic_tags_taxonomy() {
 
  $labels = array(
    'name' => _x( 'Mautic tags', 'taxonomy general name' ),
    'singular_name' => _x( 'Mautic tag', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Mautic tags' ),
    'all_items' => __( 'All Mautic tags' ),
    'parent_item' => __( 'Parent Mautic tag' ),
    'parent_item_colon' => __( 'Parent Mautic tag:' ),
    'edit_item' => __( 'Edit Mautic tag' ), 
    'update_item' => __( 'Update Mautic tag' ),
    'add_new_item' => __( 'Add New Mautic tag' ),
    'new_item_name' => __( 'New Mautic tag Name' ),
    'menu_name' => __( 'Mautic tags' ),
  );    
 
// Now register the taxonomy
  register_taxonomy('mautictags', ['page', 'post', 'customer_story', 'download', 'solution', 'sector', 'vacancy', 'insight'], array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => true,
	'public' => false,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'subject' ),
  ));
 
}

add_action( 'admin_enqueue_scripts', function($hook){

    wp_enqueue_script( 'nh_vc_custom_scripts', plugins_url( '/Assets/vc_extend.js', __FILE__ ), array('jquery'), '4', true);
}, 100);

add_action( 'wp_enqueue_scripts', function($hook){

    $options = get_option('wpmautic_options');

    if(!isset($options['wpmautic_load_text']) or empty($options['wpmautic_load_text'])) {
        $options['wpmautic_load_text'] = "Even geduld...";
    }

    wp_enqueue_script( 'nh_tacking_script', plugins_url( '/Assets/newheap-tracking.js', __FILE__ ), array('jquery'), '1', true);
	//Load recaptcha library if enabled
	if(!empty($options['wpmautic_captcha_secret']) and !empty($options['wpmautic_captcha_key'])) {
        $secret = $options['wpmautic_captcha_secret'];
        if(!empty($secret)) {
			wp_enqueue_script( 'recaptcha', 'https://www.google.com/recaptcha/api.js');
		}
	}
});

add_action( 'wp_ajax_mautic_connector_form_get', function(){

    $formId = $_POST['formId'];
    $baseUrl = $_POST['baseUrl'];

    /** @var \NewHeap\Component\Mautic\Connector\Application\ApplicationKernel $mauticConnectorApplicationKernel */
    $mauticConnectorApplicationKernel = getMauticConnector();

    echo $mauticConnectorApplicationKernel->visualComposerService->loadMauticForm($baseUrl, $formId);

    wp_die();
});

if(isset($_GET['refreshMautic']) && $_GET['refreshMautic']) {
    $path = (__DIR__) . "/Application/Service/cache";
    $files = glob($path . '/*');

    foreach($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }

    $jsCachePath = __DIR__ . '/Application/Service/cache/js/';

    // Check if cached JS files if so empty it
    if (file_exists($jsCachePath)) {
        $jsFiles = glob($jsCachePath . '/*');

        foreach($jsFiles as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
    }

    function sample_admin_notice__success() {
        ?>
        <div class="notice notice-success is-dismissible">
            <p><?php _e( 'Mautic cache cleared', 'sample-text-domain' ); ?></p>
        </div>
        <?php
    }
    add_action( 'admin_notices', 'sample_admin_notice__success' );

}

function refresh_button($wp_admin_bar){
    $mauticLink = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
    if(strstr($mauticLink, "?") === false) {
        $mauticLink .= "?refreshMautic=true";
    } else {
        $mauticLink .= "&refreshMautic=true";
    }

    $args = array(
        'id' => 'refresh-mautic',
        'title' => 'Refresh Mautic Forms',
        'href' => $mauticLink,
        'meta' => array(
            'class'    => 'wpse--item',
        )
    );
    $wp_admin_bar->add_node($args);
}

add_action('admin_bar_menu', 'refresh_button', 50);

add_action( 'wp_ajax_mautic_connector_form_get_collection', function(){

    $formId = $_POST['formId'];
    $baseUrl = $_POST['baseUrl'];

    /** @var \NewHeap\Component\Mautic\Connector\Application\ApplicationKernel $mauticConnectorApplicationKernel */
    $mauticConnectorApplicationKernel = getMauticConnector();

    $mauticConnectorApplicationKernel->visualComposerService->loadMauticForm($baseUrl, $formId);

    $selectCollectionResult = call_user_func(function () use ($mauticConnectorApplicationKernel) {
        $result = [];

        if(is_array($mauticConnectorApplicationKernel->visualComposerService->selectableFormElementCollection))
        {
            foreach($mauticConnectorApplicationKernel->visualComposerService->selectableFormElementCollection as $elementModel)
            {
                $result[$elementModel->title] = $elementModel->domElementId;
            }
        }

        return $result;
    });

    echo json_encode($selectCollectionResult);

    wp_die();
});

add_action( 'wp_ajax_mautic_connector_forms_get', function(){

    $options = get_option('wpmautic_options');

    $forms = [];


    try {
        $mauticBaseUrl =  $options['base_url'] . "/api";

        $settings = array(
            'userName'   => $options['wpmautic_login_name'],
            'password'   => $options['wpmautic_login_password']
        );

        $initAuth = new \Mautic\Auth\ApiAuth();
        $auth = $initAuth->newAuth($settings, 'BasicAuth');

        $api = new \Mautic\MauticApi();
        $contactApi = $api->newApi('forms', $auth, $mauticBaseUrl);
    } catch (\Exception $e) {

    }
    $i = 0;
    if(!empty($contactApi->getList()) and !empty($contactApi->getList()['forms'])) {
        foreach($contactApi->getList(null, 0, 9999)['forms'] as $form) {
            $forms[$i]['title'] = $form['name'];
            $forms[$i]['id'] = $form['id'];
            $i++;
        }
    }

    echo json_encode(array_values($forms));

    wp_die();
});

add_action( 'wp_ajax_nopriv_mautic_connector_form_form_post', 'mauticConnectorFormFormPost');
add_action( 'wp_ajax_mautic_connector_form_form_post', 'mauticConnectorFormFormPost');

function mauticConnectorFormFormPost()
{
    $options = get_option('wpmautic_options');
    $postUrl =  $options['base_url'] . "/form/submit?formId=".$_POST['formId'];
    $formData = $_POST['formData'];

    $decoded = [];
    if($formData != null)
    {
        $decoded = json_decode(stripslashes($formData));

        $formData = [];

        foreach($decoded as $item)
        {
            $key = str_replace("mauticform[", "", $item->name);
            $key = str_replace("]", "", $key);

            $formData[$key] = $item->value;
        }
    }

    $options = get_option('wpmautic_options');

    if(!empty($options['wpmautic_captcha_secret']) and !empty($options['wpmautic_captcha_key'])) {
        $secret = $options['wpmautic_captcha_secret'];
        if(!empty($secret)) {
            $response = null;
            $url = "https://www.google.com/recaptcha/api/siteverify?secret=".$secret."&response=".$formData["g-recaptcha-response"];
            $verifyResponse = json_decode(file_get_contents($url));

            if (!$verifyResponse->success) {
                ?>
                {"success":0,"validationErrors":{"catpcha":"Zorg dat de Catcha is ingevuld."}}
                <?php
                die();
            }
        }
    }
    
    if ($formData["phone"] != "aMd039aNF!3n5ja") {
        ?>
        {"success":0,"validationErrors":{"catpcha":"Validatie van robot check mislukt. Zorg dat javascript ingesteld staat."}}
        <?php
        die();
    }

    $getClientIp = function(){

        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';

        return $ipaddress;
    };



    //$formData["return"] = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $formData["messenger"] = "1";

    /** @var \NewHeap\Component\Mautic\Connector\Application\ApplicationKernel $mauticConnectorApplicationKernel */
    $mauticConnectorApplicationKernel = getMauticConnector();
    $clientIp = $getClientIp();

    // Store the form data in the database so we have a log
    $formSubmissionId = FormSubmissions::register_form_submission($postUrl . "&utm_source=".$_POST['utm_source']."&utm_medium=".$_POST['utm_medium']."&utm_campaign=".$_POST['utm_campaign'], array('mauticform' => $formData), array("X-FORWARDED-FOR: $clientIp"));

    // Post the data to Mautic
    $plainResponse = $mauticConnectorApplicationKernel->httpService->postRequest($postUrl . "&utm_source=".$_POST['utm_source']."&utm_medium=".$_POST['utm_medium']."&utm_campaign=".$_POST['utm_campaign'], array('mauticform' => $formData), array("X-FORWARDED-FOR: $clientIp"));

    $getBetweenString = function($var1="",$var2="",$pool) {
        $temp1 = strpos($pool, $var1) + strlen($var1);
        $result = substr($pool, $temp1, strlen($pool));
        $dd = strpos($result, $var2);
        if ($dd == 0) {
            $dd = strlen($result);
        }

        return substr($result,0,$dd);
    };

    $response = $getBetweenString('parent.postMessage("', "\"", $plainResponse);

    //
    // Weird mautic response.. convert
    //
    $format = function($string)
    {
        return preg_replace_callback('#\\\\x([[:xdigit:]]{2})#ism', function($matches)
        {
            return chr(hexdec($matches[1]));
        }, $string);
    };

    $formatted_response = json_decode($format($response));

    // Check if success
    if (property_exists($formatted_response, 'success') &&
        $formatted_response->success === FormSubmissions::FORM_SUBMISSION_STATE_SUCCESS) {
        FormSubmissions::update_submission_sync_state($formSubmissionId, FormSubmissions::FORM_SUBMISSION_STATE_SUCCESS);
    }

    echo $format($response);

    wp_die();
}


class MailChimp2 {
    private $api_key = '-us11';
    private $api_url = 'https://us11.api.mailchimp.com/3.0';
    protected $list_id = '';


    public function __construct()
    {
    }

    /**
     * Subscribe user to list
     *
     * @param $email
     * @param $firstname
     * @param $lastname
     * @param bool $list_id
     */
    public function subscribe_to_list( $email, $firstname, $lastname, $list_id = false ) {
        // If no list provide choose the default list
        if( $list_id ) {
            $this->list_id = $list_id;
        }

        $subscriber = array(
            'apikey'        => $this->api_key,
            'email_address' => $email,
            'status'        => 'subscribed',
            'merge_fields'  => array(
                'FNAME' => $firstname,
                'LNAME' => $lastname,
            )
        );


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->api_url . '/lists/' . $this->list_id . '/members/');
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json',
            'Authorization: Basic '.$this->api_key));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($subscriber));
        $result = curl_exec($ch);
    }

    /**
     * Unsubscribe email from list
     *
     * @param $email
     * @param bool $list_id
     */
    public function ubsubscribe_from_list( $email, $list_id = false ) {
        // If no list provide choose the default list
        if( $list_id ) {
            $this->list_id = $list_id;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->api_url . '/lists/' . $this->list_id . '/members/' . md5($email));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json',
            'Authorization: Basic '.$this->api_key));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
    }
}


/** Updater */
add_filter('site_transient_update_plugins', 'mautic_connector_push_update' );

/** Todo: delete **/
function gw_curl_setopt_ipresolve( $handle ){
    curl_setopt( $handle, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
    return $handle;
}
if( function_exists( 'gw_curl_setopt_ipresolve' ) ){
    add_action( 'http_api_curl', 'gw_curl_setopt_ipresolve', 10, 1);
}
/** end todo */

function mautic_connector_push_update( $transient ){

    if ( empty($transient->checked ) ) {
        return $transient;
    }

    // trying to get from cache first, to disable cache comment 10,20,21,22,24
    if( false == $remote = get_transient( 'mautic_upgrade_mautic-connector' ) ) {

        // info.json is the file with the actual plugin information on your server
        $remote = wp_remote_get( 'https://assets.nu/marketingheap/plugins/mautic-connector/info.json', array(
                'timeout' => 10,
                'sslverify' => false,
                'headers' => array(
                    'Accept' => 'application/json'
                ) )
        );

        if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && $remote['response']['code'] == 200 && !empty( $remote['body'] ) ) {
            set_transient( 'mautic_upgrade_mautic-connector', $remote, 13200 ); // 12 hours cache
        }

    }

    if( $remote ) {

        if(is_object($remote)) {
            return $transient;
        }

        $remote = json_decode( $remote['body'] );

        $plugin_data = get_file_data(__FILE__, array('Version' => 'Version'), false);
        $plugin_version = $plugin_data['Version'];

        // your installed plugin version should be on the line below! You can obtain it dynamically of course
        if( $remote && version_compare( $plugin_version, $remote->version, '<' ) && version_compare($remote->requires, get_bloginfo('version'), '<' ) ) {
            $res = new stdClass();
            $res->slug = 'mautic-connector';
            $res->plugin = 'mautic-connector/Main.php'; // it could be just YOUR_PLUGIN_SLUG.php if your plugin doesn't have its own directory
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;
            $res->url = $remote->homepage;
            $transient->response[$res->plugin] = $res;
            //$transient->checked[$res->plugin] = $remote->version;
        }

    }
    return $transient;
}

add_action( 'upgrader_process_complete', 'mautic_connector_after_update', 10, 2 );

function mautic_connector_after_update( $upgrader_object, $options ) {
    if ( $options['action'] == 'update' && $options['type'] === 'plugin' )  {
        delete_transient( 'mautic_upgrade_mautic-connector' );
    }
}

add_filter( 'cron_schedules', 'mautic_add_cron_interval' );
function mautic_add_cron_interval( $schedules ) { 
    $schedules['mautic_five_minutes'] = array(
        'interval' => 60 * 5,
        'display'  => esc_html__( 'Mautic Every Five Minutes' ), );
    return $schedules;
}

new PageHits();
new FormSubmissions();

function cron_mautic_cron_process_not_synced_submissions() {
    $mauticFormSubmissions = new FormSubmissions();
    $mauticFormSubmissions->get_not_synced_submissions();
}

add_action('init', function() {
    add_action( 'mautic_cron_process_not_synced_submissions', 'cron_mautic_cron_process_not_synced_submissions' );
 
    if (! wp_next_scheduled ( 'mautic_cron_process_not_synced_submissions' )) {
        wp_schedule_event( time(), 'mautic_five_minutes', 'mautic_cron_process_not_synced_submissions' );
    }
});
