<?php

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	echo 'This file should not be accessed directly!';
	exit; // Exit if accessed directly
}

function wpmautic_options_page()
{ ?>
	 <div>
		<h2>WP Mautic</h2>
		<p>Enable Base URL for Mautic Integration.</p>
		<form action="options.php" method="post">
			<?php settings_fields('wpmautic_options'); ?>
			<?php do_settings_sections('wpmautic'); ?>
			<input name="Submit" type="submit" value="<?php esc_attr_e('Save Changes'); ?>" />
		</form>
		<p>Shortcode example for Mautic Form Embed: <code>[mauticform id="1"]</code></p>
		<h3>Quick Links</h3>
		<ul>
			<li>
				<a href="https://github.com/mautic/mautic-wordpress#mautic-wordpress-plugin" target="_blank">Plugin docs</a>
			</li>
			<li>
				<a href="https://github.com/mautic/mautic-wordpress/issues" target="_blank">Plugin support</a>
			</li>
			<li>
				<a href="https://mautic.org" target="_blank">Mautic project</a>
			</li>
			<li>
				<a href="http://docs.mautic.org/" target="_blank">Mautic docs</a>
			</li>
			<li>
				<a href="https://www.mautic.org/community/" target="_blank">Mautic forum</a>
			</li>
		</ul>
	</div>
<?php
}

add_action('admin_init', 'wpmautic_admin_init');

function wpmautic_admin_init()
{
	register_setting( 'wpmautic_options', 'wpmautic_options', 'wpmautic_options_validate' );
	add_settings_section('wpmautic_main', 'Main Settings', 'wpmautic_section_text', 'wpmautic');
	add_settings_field('wpmautic_base_url', 'Mautic Base URL', 'wpmautic_base_url', 'wpmautic', 'wpmautic_main');
    add_settings_field('wpmautic_captcha_key', 'Google captcha key', 'wpmautic_captcha_key', 'wpmautic', 'wpmautic_main');
    add_settings_field('wpmautic_captcha_secret', 'Google captcha secret', 'wpmautic_captcha_secret', 'wpmautic', 'wpmautic_main');
    add_settings_field('wpmautic_login_name', 'Mautic API login name', 'wpmautic_login_name', 'wpmautic', 'wpmautic_main');
    add_settings_field('wpmautic_login_password', 'Mautic API password', 'wpmautic_login_password', 'wpmautic', 'wpmautic_main');
    add_settings_field('wpmautic_load_text', 'Loading text (For other languages, use WPML string translations)', 'wpmautic_load_text', 'wpmautic', 'wpmautic_main');
}

function wpmautic_section_text()
{
}

function wpmautic_base_url()
{
	$options = get_option('wpmautic_options');
	echo "<input id='wpmautic_base_url' name='wpmautic_options[base_url]' size='40' type='text' placeholder='http://...' value='{$options['base_url']}' />";
	echo "<span style='margin-left: 10px;'>" . __('Include "https://" and remove trailing slash!', 'newheap') . "</span>";
}


function wpmautic_captcha_key()
{
    $options = get_option('wpmautic_options');
    echo "<input id='wpmautic_captcha_key' name='wpmautic_options[wpmautic_captcha_key]' size='100' type='text' placeholder='Google captcha key' value='{$options['wpmautic_captcha_key']}' />";
}


function wpmautic_captcha_secret()
{
    $options = get_option('wpmautic_options');
    echo "<input id='wpmautic_captcha_secret' name='wpmautic_options[wpmautic_captcha_secret]' size='100' type='text' placeholder='Google captcha secret' value='{$options['wpmautic_captcha_secret']}' />";
}

function wpmautic_login_name()
{
    $options = get_option('wpmautic_options');
    echo "<input id='wpmautic_login_name' name='wpmautic_options[wpmautic_login_name]' size='100' type='text' placeholder='Mautic API login name' value='{$options['wpmautic_login_name']}' />";
}

function wpmautic_login_password()
{
    $options = get_option('wpmautic_options');
    echo "<input id='wpmautic_login_password' name='wpmautic_options[wpmautic_login_password]' size='100' type='password' placeholder='Mautic API password' value='{$options['wpmautic_login_password']}' />";
}


function wpmautic_load_text()
{
    $options = get_option('wpmautic_options');
    echo "<input id='wpmautic_load_text' name='wpmautic_options[wpmautic_load_text]' size='100' type='text' placeholder='Even geduld...' value='{$options['wpmautic_load_text']}' />";
}



function wpmautic_options_validate($input)
{
	$options = get_option('wpmautic_options');
	$options['base_url'] = trim($input['base_url']);
    $options['wpmautic_captcha_key'] = trim($input['wpmautic_captcha_key']);
    $options['wpmautic_captcha_secret'] = trim($input['wpmautic_captcha_secret']);
    $options['wpmautic_login_name'] = trim($input['wpmautic_login_name']);
    $options['wpmautic_login_password'] = trim($input['wpmautic_login_password']);
    $options['wpmautic_load_text'] = trim($input['wpmautic_load_text']);

	return $options;
}
