<?php
// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
    header( 'HTTP/1.0 403 Forbidden' );
    echo 'This file should not be accessed directly!';
    exit; // Exit if accessed directly
}

// Store plugin directory
define( 'VPMAUTIC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
// Store plugin main file path
define( 'VPMAUTIC_PLUGIN_FILE', __FILE__ );

add_action('admin_menu', 'wpmautic_settings');
add_action( 'wp_enqueue_scripts', 'wpmautic_function' );
add_shortcode('mauticform', 'wpmautic_shortcode');

function wpmautic_settings()
{
    include_once(dirname(__FILE__) . '/options.php');
    add_options_page('WP Mautic Settings', 'WPMautic', 'manage_options', 'wpmautic', 'wpmautic_options_page');
}

/**
 * Settings Link in the ``Installed Plugins`` page
 */
function wpmautic_plugin_actions( $links, $file ) {
    if( $file == plugin_basename( VPMAUTIC_PLUGIN_FILE ) && function_exists( "admin_url" ) ) {
        $settings_link = '<a href="' . admin_url( 'options-general.php?page=wpmautic' ) . '">' . __('Settings') . '</a>';
        // Add the settings link before other links
        array_unshift( $links, $settings_link );
    }
    return $links;
}
add_filter( 'plugin_action_links', 'wpmautic_plugin_actions', 10, 2 );

/**
 * Writes Tracking image to the HTML source of WP
 */
function wpmautic_function( $atts, $content = null )
{
    // TODO: Check if we can remove this function
    // Get the options
    $options = get_option('wpmautic_options');

    // Enqueue script
    wp_enqueue_script('nh-mautic', plugins_url( '/Assets/vc_extend_frnt.js?d=2', __FILE__ ), [], false, true);

//    $mtcJsUrl = 'https://' . $options['base_url'] . '/mtc.js';

    // Get the JavaScript
//    $js = get_mautic_js_file($mtcJsUrl);

//    $image = $js;

//    $image .= "(function(w,d,t,u,n,a,m){
//        w['MauticTrackingObject']=n;
//        w[n]=w[n] || function(){}
//    })
//    (window,document,'script','','mt');";
//    $image .= "mt('send', 'pageview');" . 'var mauticLoadText = "'.__($options['wpmautic_load_text'], "Mautic connector").'";';

	$tags = [];
	foreach(get_the_terms(null, 'mautictags') as $mautictag) {
		$tags[] = $mautictag->name;
	}
    $image = 'var mauticLoadText = "' . __($options['wpmautic_load_text'], "Mautic connector") . '"; var MauticTags = '.json_encode($tags).';';
    wp_add_inline_script('nh-mautic', $image, 'after');
    wp_localize_script( 'nh-mautic', 'nh_mautic_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

}

/**
 * Handle mauticform shortcode
 * example: [mauticform id="1"]
 *
 * @param  array $atts
 * @return string
 */
function wpmautic_shortcode( $atts )
{
    $options = get_option('wpmautic_options');
    $base_url = trim($options['base_url'], " \t\n\r\0\x0B/");
    $mauticform = shortcode_atts(array('id'), $atts);

    $scripts = '<script src="' . get_mautic_js_file('https://' . $base_url . '/form/generate.js?id=' . $atts['id'], true) . '"></script>';
    $scripts .= '<script>' . get_mautic_form_js($base_url) . '</script>';

    return $scripts;
}

/**
 * Builds and returns additional data for URL query
 *
 * @return array
 */
function wpmautic_get_url_query()
{
    global $wp;
    $current_url = add_query_arg( $wp->query_string, '', home_url( $wp->request ) );

    $attrs = array();
    $attrs['title']	 = wpmautic_wp_title();
    $attrs['language']  = get_locale();
    $attrs['referrer']  = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $current_url;
    $attrs['url']	   = $current_url;
    return $attrs;
}

/**
 * Creates a nicely formatted and more specific title element text
 * for output in head of document, based on current view.
 *
 * @param string $title Default title text for current view.
 * @param string $sep Optional separator.
 * @return string Filtered title.
 */
function wpmautic_wp_title( $title = '', $sep = '' ) {
    global $paged, $page;

    if ( is_feed() )
        return $title;

    // Add the site name.
    $title .= trim(wp_title($sep, false));

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 )
        $title = "$title $sep " . sprintf( __( 'Page %s', 'twentytwelve' ), max( $paged, $page ) );

    return $title;
}

function get_mautic_form_js($base_url) {
    return get_mautic_js_file('https://' . $base_url . '/media/js/mautic-form.js');
}

function get_mautic_js_file($url, $returnUrl = false) {
    $options = get_option('wpmautic_options');
    $base_url = 'https://' . trim($options['base_url'], " \t\n\r\0\x0B/");

    $path = __DIR__ . '/Application/Service/cache/js';
    $cacheFile = $path . '/' . md5($url) . '.js';

    // Check if we have a cached version
    if (file_exists($cacheFile)) {
        $httpResponseString = file_get_contents($cacheFile, true);
    } else {

        // Check if folder exists
        if (!is_dir($path)) {
            mkdir(__DIR__ . '/Application/Service/cache/js', 0755, true);
        }

        // Get the remote file content
        $httpResponseString = NewHeap\Component\Mautic\Connector\Application\Service\HttpService::getRequest($url);

        // Remove mautic-form.js & modal.min.css
        $httpResponseString = str_replace(
            [$base_url . '/media/js/mautic-form.js', $base_url . '/media/css/modal.min.css', $base_url . '/mtc/event'],
            ['', '', ''],
            $httpResponseString
        );

        // Save a cached version
        $myfile = fopen($cacheFile, "w") or die("Unable to open file!");
        fwrite($myfile, $httpResponseString);
    }

    // Check if we should return the url or path
    if ($returnUrl) {
        return plugin_dir_url(__FILE__) . 'Application/Service/cache/js/' . md5($url) . '.js';;
    } else {
        return $httpResponseString;
    }
}
